# Repository Guidelines

## Overview
This repository is a PrestaShop module (module name: `whatsboost`). Install it under `modules/whatsboost/` in your PrestaShop instance.

## Project Structure & Module Organization
- Module entry point: `whatsboost.php` (root).
- Controllers: `controllers/front/*.php` for front‑office routes; other hooks in `controllers/*.php`.
- Templates (Smarty): `views/templates/{admin,front,hook}/*.tpl`.
- Assets: CSS in `views/css/*.css`, images in `views/img/`.
- Translations: `translations/*.php` (e.g., `translations/es.php`).
- Admin pages and assets: `ficheros/*.php`, `ficheros/*.css`.

## Build, Test, and Development Commands
- Install Composer deps (if any): `composer install`
- Refresh autoload (optimized): `composer dump-autoload -o`
- PHP lint (one file): `php -l controllers/front/display.php`
- PHP lint (all, PowerShell): `Get-ChildItem -Recurse -Filter *.php | % { php -l $_.FullName }`
- Run locally: place this folder under your PrestaShop install at `modules/whatsboost/`, enable the module in the back office, and test front/admin templates.

## Coding Style & Naming Conventions
- PHP: PSR‑12, 4‑space indentation, `StudlyCaps` classes, `camelCase` methods/properties.
- Templates: keep filenames lower‑case with hyphens (e.g., `welcome.tpl`), prefer small, focused blocks.
- Escaping: always escape template output, e.g. `{$var|escape:'htmlall':'UTF-8'}`.
- Strings: use translation helpers and update `translations/es.php` for new labels.

## Testing Guidelines
- No PHPUnit configured; use lint + manual functional checks in PrestaShop.
- Verify hooks render correctly (e.g., `views/templates/hook/displayHome.tpl`).
- For new controllers, create a matching template and validate the route under `/module/whatsboost/<controller>`.

## Commit & Pull Request Guidelines
- Prefer Conventional Commits: `feat:`, `fix:`, `docs:`, `refactor:`, `chore:`.
- PRs should include: clear summary, affected paths, steps to reproduce/test, and screenshots for admin UI changes.
- Keep PRs focused and small; link related issues or tickets.

## Security & Configuration Tips
- Never commit secrets or access tokens.
- Sanitize request data (`$_GET`, `$_POST`) using PrestaShop utilities and validate before use.
- Avoid raw SQL in controllers; use the platform’s DB layer. Escape all variables in templates.

## Agent‑Specific Instructions
- Follow existing folder patterns and naming. Keep changes minimal and scoped.
- Do not rename public classes, hooks, or routes without discussion.
- When adding user‑facing strings, update `translations/es.php` and confirm back‑office renders correctly.
