{* Global BO notices: 1) missing/invalid key, 2) missing unique (no OK here) *}
<div id="wb-admin-wrap" class="wb-admin-wrap" aria-live="polite">
  <div id="wb-admin-key" class="wb-toast wb-toast--warn{if !$wb_key_should_show} is-hidden{/if}" role="status">
    <div class="wb-toast__inner">
      <strong>WhatsBoost:</strong>
      <span class="wb-toast__text" data-i18n="global.key.text">
        {l s='Para empezar a enviar WhatsApps necesitas introducir tu clave de licencia de WhatsBoost y asociar tu número. Es rápido y seguro — la obtienes en pocos pasos desde la documentación o la sección de ajustes.' mod='whatsboost'}
      </span>
      <div class="wb-toast__actions">
        <a class="wb-btn wb-btn-primary" href="{$wb_settings_url|escape:'htmlall':'UTF-8'}" data-i18n="global.key.btn">{l s='Abrir ajustes de WhatsBoost' mod='whatsboost'}</a>
      </div>
    </div>
  </div>

  <div id="wb-admin-unique" class="wb-toast wb-toast--info{if !$wb_unique_should_show} is-hidden{/if}" role="status">
    <div class="wb-toast__inner">
      <strong>WhatsBoost:</strong>
      <span class="wb-toast__text" data-i18n="global.unique.text">
        {l s='Tu clave está verificada, pero falta vincular el número de WhatsApp (id_unique) desde el que enviarás los mensajes. Elige o conecta una cuenta para completar la configuración.' mod='whatsboost'}
      </span>
      <div class="wb-toast__actions">
        <a class="wb-btn wb-btn-primary" href="{$wb_settings_url|escape:'htmlall':'UTF-8'}#wb_accounts_section" data-i18n="global.unique.btn">{l s='Vincular número ahora' mod='whatsboost'}</a>
      </div>
    </div>
  </div>
</div>

{literal}
<style>
/* Floating stack (bottom-right) */
.wb-admin-wrap{position:fixed;right:16px;bottom:16px;z-index:99999;display:flex;flex-direction:column;gap:10px;align-items:flex-end;pointer-events:none;isolation:isolate}
.wb-toast{pointer-events:auto;max-width:560px;width:calc(100vw - 32px);border-radius:8px;border:1px solid transparent;box-shadow:0 8px 20px rgba(0,0,0,.15);background:#fff}
.wb-toast.is-hidden{display:none}
.wb-toast__inner{margin:0;padding:12px 14px;color:#111827;display:flex;align-items:center;gap:12px;flex-wrap:wrap}
.wb-toast__text{color:#374151}
.wb-toast__actions{margin-left:auto;display:flex;gap:8px}
.wb-toast--warn{background:#FEF3C7;border-color:#FDE68A;border-left:6px solid #F59E0B}
.wb-toast--info{background:#DBEAFE;border-color:#BFDBFE;border-left:6px solid #3B82F6}
.wb-btn{display:inline-block;padding:8px 12px;border-radius:6px;border:1px solid transparent;text-decoration:none;cursor:pointer;font-weight:600}
.wb-btn-primary{background:#2563eb;border-color:#1d4ed8;color:#fff}
.wb-btn-secondary{background:#fff;border-color:#cbd5e1;color:#111}
@media (max-width: 720px){.wb-admin-wrap{left:12px;right:12px;bottom:12px}.wb-toast__actions{width:100%;margin-left:0;justify-content:flex-start}.wb-toast__inner{justify-content:space-between}}
</style>
<script>
(function(){
  var keyBox = document.getElementById('wb-admin-key');
  var uniqueBox = document.getElementById('wb-admin-unique');
  var wrap = document.getElementById('wb-admin-wrap');
  var statusUrl = '{/literal}{$wb_status_url|escape:'javascript':'UTF-8'}{literal}';
  if(!keyBox && !uniqueBox){ return; }

  function toggle(el, show){ if(!el) return; if(show){ el.classList.remove('is-hidden'); } else { el.classList.add('is-hidden'); } }

  function ensureToBody(){
    try{
      if(!wrap){ wrap = document.getElementById('wb-admin-wrap'); }
      if(!wrap){ return; }
      // If wrapper is not a direct child of BODY, move it to BODY to escape any stacking context
      if(wrap.parentElement && wrap.parentElement.tagName !== 'BODY'){
        document.body.appendChild(wrap);
      }
    }catch(e){}
  }

  function adjustBottomOffset(){
    try{
      ensureToBody();
      if(!wrap){ wrap = document.getElementById('wb-admin-wrap'); }
      if(!wrap){ return; }
      var footer = document.querySelector('.whatsboost-footer');
      var base = 16;
      var extra = 0;
      if(footer){
        var rect = footer.getBoundingClientRect();
        var h = footer.offsetHeight || rect.height || 0;
        var vpH = window.innerHeight || document.documentElement.clientHeight || 0;
        // Añadir offset solo si el footer está tocando el borde inferior del viewport (solaparía a los avisos)
        var touching = (rect.bottom >= vpH - 1) && (rect.top < vpH) && h > 0;
        if(touching){ extra = Math.max(0, Math.round(h)); }
      }
      wrap.style.bottom = (base + extra) + 'px';
    }catch(e){}
  }

  function check(){
    var body = 'ajax=1&action=status';
    fetch(statusUrl, { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: body, credentials:'same-origin' })
      .then(function(r){ return r.text().then(function(t){ return { ok:r.ok, status:r.status, text:t }; }); })
      .then(function(resp){ var json=null; try{ json = JSON.parse(resp.text||'{}'); }catch(e){}
        if(resp.ok && json){
          if(!!json.show_key){
            toggle(keyBox, true);
            toggle(uniqueBox, false);
          } else if(!!json.show_unique){
            toggle(uniqueBox, true);
            toggle(keyBox, false);
          } else {
            toggle(keyBox, false);
            toggle(uniqueBox, false);
          }
        }
        // Ajustar tras actualizar visibilidad por si cambia el alto del stack
        try{ adjustBottomOffset(); setTimeout(adjustBottomOffset, 50); setTimeout(adjustBottomOffset, 300); }catch(e){}
      })
      .catch(function(){ /* keep state */ });
  }

  // Expose manual refresh so other scripts (verificación) puedan forzar el estado al instante
  try { window.wbStatusRefresh = function(){ check(); adjustBottomOffset(); }; } catch(e){}
  // Ajustes iniciales y listeners
  try { setTimeout(check, 800); } catch(e){}
  try { setInterval(check, 8000); } catch(e){}
  try { document.addEventListener('DOMContentLoaded', adjustBottomOffset); } catch(e){}
  try { window.addEventListener('resize', adjustBottomOffset); } catch(e){}
  // Ajuste periódico por si cambia la altura del footer dinámicamente
  try { setInterval(adjustBottomOffset, 2000); } catch(e){}
  // Primer ajuste inmediato
  adjustBottomOffset();
})();
</script>
{/literal}


{literal}
<script>
(function(){
  try{
    var lang = (document.documentElement.getAttribute('lang')||'').toLowerCase();
    if(lang.indexOf('en') !== 0){ return; }
    var t = {
      'global.key.text': 'To start sending WhatsApps you need to enter your WhatsBoost license key and link your number. It\u2019s quick and secure \u2014 you can get it in a few steps from the documentation or the settings section.',
      'global.key.btn': 'Open WhatsBoost settings',
      'global.unique.text': 'Your key is verified, but the WhatsApp number (id_unique) from which you will send messages is missing. Choose or connect an account to finish the setup.',
      'global.unique.btn': 'Link number now'
    };
    var scope = document.getElementById('wb-admin-wrap') || document;
    scope.querySelectorAll('[data-i18n]').forEach(function(el){
      var k = el.getAttribute('data-i18n');
      if(t[k]){ el.textContent = t[k]; }
    });
  }catch(e){}
})();
</script>
{/literal}
